import Utilities.visa_operations as vo
import Utilities.gui_creator as gc

root = gc.create_window(
               title='VISA Query (Service Request)',
               size='500x450')

resource_name = \
           'USB0::0x0957::0x0607::MY47022122::INSTR'

rm, dmm = vo.open_session(resource_name)

def perform_query():

    vo.status_config_srq(dmm)
    command = gc.get_control_string(var_ent)
    vo.write_instrument(dmm, command)
    vo.wait_for_srq(dmm)
    response = vo.read_instrument(dmm)
    response = response[:-1]
    stx.delete(1.0, 'end')
    stx.insert(1.0, response)

    return


var_ent = gc.create_control(root, label='Command',
                            char_width=60)

stx = gc.create_text_box(root, label='Response',
                         char_width=55, lines=20)

btn = gc.action_button(root, label='Submit',
                       action=perform_query)

root.mainloop()

vo.close_session_srq(rm, dmm)

